#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//odd structuresMod01.fsh   by   sukupaper
//https://www.shadertoy.com/view/NsfSWj
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

// Author: paperu
// Title: odd structures

const float P = 6.28318;

float t;
int matId;
vec3 map, pOffset;

mat2 rot(in float a) { return mat2(cos(a), sin(a), -sin(a), cos(a)); }

float box(in vec3 p, in float s, in float r) { return length(max(abs(p) - s, 0.)) - r; }
float ibox(in vec3 p, in float s) { p = abs(p) - s; return min(max(p.y, p.z), min(max(p.x, p.y), max(p.x, p.z))); }

float df(in vec3 p) {
    p += pOffset;
    
    vec3 pp = map = mod(p, 4.) - 2.;
    p = mod(p - .5, 1.) - .5;
    
    float b1 = max(box(p, .45, .02), -ibox(p, .4));
    p = abs(p) - .5;
    float b2 = max(box(p, .15, .01), -ibox(p, .125));
    float b3 = max(box(pp, 1.3, .01), -ibox(pp, 1.25));
    
    float d = min(min(b1, b2), b3);
    matId = d == b1 ? 1 : d == b2 ? 2 : 3;
    return d;
}

struct rmRes { vec3 pos; int it; bool hit; };
rmRes rm(in vec3 c, in vec3 r) {
    rmRes res; res.pos = c, res.hit = true, res.it = 0;
    for(int i = 0; i < 25; i++) {
        float d, dd;
        if((d = df(res.pos)) < .0001) return res;
        res.pos += d*(r += r*d*.075);
        mat2 rt = rot(d*.25); r.xy *= rt, r.xz *= rt, r.yz *= rt;
        res.it++;
    }
    res.hit = false;
    return res;
}

vec3 plane2sphere(in vec2 p) {
    float t = -4./(dot(p,p) + 4.);
    return vec3(-p*t, 1. + 2.*t);
}

float anim1(in float x, in float off, in float steps) {
    x += off;
    return (1. - min(mod(floor(x + 1.), steps), 1.))*smoothstep(0., 1., fract(x)) + floor(x/steps);
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
    vec2 st = (fragCoord.xy - .5*iResolution.xy)/iResolution.x;
    
    t = iTime*.5 + .75;
    float a[6];
    for(int i = 0; i < 6; i++)
        a[i] = anim1(t, float(i), 6.);
    pOffset = vec3(a[1] + a[5], a[0] - a[3], a[2] - a[4]);
    
    vec3 c = vec3(0., 0., -5.), r = plane2sphere(st*P*1.5);
    mat2 rt = rot(t*.75); r.xy *= rt, r.xz *= rt, r.yz *= rt;
    
    rmRes res = rm(c,r);
    
    vec3 color = vec3(0.);
    if(res.hit) {
        color = matId == 1 ? vec3(.174, .239, .765)
            : matId == 2 ? vec3(1., .23, .249)
            : vec3(1., .681, .049)*step(.5,fract((map.x + map.y + map.z)*10.));
    }
    float dist = distance(res.pos, c);
    color += dist*.025;
    color -= pow(max(0., float(res.it)*.0225),2.);
	color = mix(color, color.ggg, min(1., dist*dist*dist*.08));
    
    fragColor = vec4(color, 1.);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

